var gender_pie_element = document.getElementById('gender_pie');
var gender_pie = echarts.init(gender_pie_element);

var jenis_pie_element = document.getElementById('jenis_pie');
var jenis_pie = echarts.init(jenis_pie_element);

var pendidikan_pie_element = document.getElementById('pendidikan_pie');
var pendidikan_pie = echarts.init(pendidikan_pie_element);


function setupJenisAnggotaPie(dataRaw) {
    var asn = 0,
        asnjfp = 0,
        nonasn = 0;

    $.each(dataRaw, function(i, data) {
        if (data.jenis_anggota === 'ASN') {
            if (data.jenis_anggota_asn === 'ASN JFP') asnjfp++;
            else asn++;
        } else nonasn++;
    });

    jenis_pie.setOption({
        color: ['#f5994e', '#588dd5', '#95706d'],
        textStyle: {
            fontFamily: 'Roboto, Arial, Verdana, sans-serif',
            fontSize: 13
        },
        title: {
            text: 'Statistik Berdasarkan Jenis Anggota',
            subtext: 'Anggota Aktif Himpenindo',
            left: 'center',
            textStyle: {
                fontSize: 17,
                fontWeight: 500
            },
            subtextStyle: {
                fontSize: 12
            }
        },
        tooltip: {
            trigger: 'item',
            backgroundColor: 'rgba(0,0,0,0.75)',
            padding: [10, 15],
            textStyle: {
                fontSize: 13,
                fontFamily: 'Roboto, sans-serif'
            },
            formatter: "{b} <br/>{c} Orang ({d}%)"
        },
        legend: {
            bottom: 15,
            left: 'center',
            data: ['ASN', 'ASN JFP', 'Non ASN'],
            itemHeight: 8,
            itemWidth: 8
        },
        series: [{
            name: 'Anggot Aktif Himpenindo',
            type: 'pie',
            itemStyle: {
                normal: {
                    label: {
                        show: false
                    },
                    labelLine: {
                        show: false
                    }
                }
            },
            data: [{
                    value: asn,
                    name: 'ASN'
                },
                {
                    value: asnjfp,
                    name: 'ASN JFP'
                },
                {
                    value: nonasn,
                    name: 'Non ASN'
                }
            ]
        }]
    });
}


function setupGenderPie(dataRaw) {
    var pria = 0,
        wanita = 0,
        labelData = [],
        total = 0,
        persenPria = 0,
        persenWanita = 0

    $.each(dataRaw, function(i, data) {
        if (data.gender === 'Perempuan') wanita++;
        else pria++;

        total++;
    });

    persenPria = pria / total * 100;
    persenWanita = wanita / total * 100;

    var dataStyle = {
        normal: {
            borderWidth: 1,
            borderColor: '#fff',
            label: {
                show: false
            },
            labelLine: {
                show: false
            }
        }
    };
    var placeHolderStyle = {
        normal: {
            color: 'transparent',
            borderWidth: 0
        }
    };

    gender_pie.setOption({
        color: ['#588dd5', '#f5994e'],
        textStyle: {
            fontFamily: 'Roboto, Arial, Verdana, sans-serif',
            fontSize: 13
        },

        title: {
            text: 'Statistik Berdasarkan Gender',
            subtext: 'Anggota Aktif Himpenindo',
            left: 'center',
            textStyle: {
                fontSize: 17,
                fontWeight: 500
            },
            subtextStyle: {
                fontSize: 12
            }
        },

        tooltip: {
            show: false
        },
        legend: {
            orient: 'vertical',
            left: 'center',
            top: '45%',
            data: [persenPria.toFixed(2) + '% Pria (' + pria + ' Orang)', persenWanita.toFixed(2) + '% Wanita (' + wanita + ' Orang)'],
            itemHeight: 8,
            itemWidth: 8,
            itemGap: 10
        },
        series: [{
                type: 'pie',
                cursor: 'default',
                clockWise: false,
                radius: ['68%', '83%'],
                hoverOffset: 0,
                itemStyle: dataStyle,
                data: [{
                        value: persenPria.toFixed(2),
                        name: persenPria.toFixed(2) + '% Pria (' + pria + ' Orang)'
                    },
                    {
                        value: 100 - persenPria,
                        name: 'invisible',
                        silent: false,
                        itemStyle: placeHolderStyle
                    }
                ]
            },

            {
                type: 'pie',
                cursor: 'default',
                clockWise: false,
                radius: ['53%', '68%'],
                hoverOffset: 0,
                itemStyle: dataStyle,
                data: [{
                        value: persenWanita.toFixed(2),
                        name: persenWanita.toFixed(2) + '% Wanita (' + wanita + ' Orang)'
                    },
                    {
                        value: 100 - persenWanita,
                        name: 'invisible',
                        silent: false,
                        itemStyle: placeHolderStyle
                    }
                ]
            }
        ]
    });
}


function setupPendidikanPie(dataRaw) {
    var s1 = 0,
        s2 = 0,
        s3 = 0;

    $.each(dataRaw, function(i, data) {
        if (data.pendidikan === '01') s1++;
        else if (data.pendidikan === '02') s2++;
        else if (data.pendidikan === '03') s3++;
    });


    pendidikan_pie.setOption({
        color: ['#9a7fd1', '#588dd5', '#f5994e'],
        textStyle: {
            fontFamily: 'Roboto, Arial, Verdana, sans-serif',
            fontSize: 13
        },
        title: {
            text: 'Statistik Berdasarkan Pendidikan',
            subtext: 'Anggota Aktif Himpenindo',
            left: 'center',
            textStyle: {
                fontSize: 17,
                fontWeight: 500
            },
            subtextStyle: {
                fontSize: 12
            }
        },

        tooltip: {
            trigger: 'item',
            backgroundColor: 'rgba(0,0,0,0.75)',
            padding: [10, 15],
            textStyle: {
                fontSize: 13,
                fontFamily: 'Roboto, sans-serif'
            },
            formatter: "{b} <br/>{c} Orang ({d}%)"
        },
        legend: {
            bottom: 15,
            left: 'center',
            data: ['Sarjana', 'Master', 'Doktor'],
            itemHeight: 8,
            itemWidth: 8
        },
        series: [{
            name: 'Pendidikan',
            type: 'pie',
            radius: ['40%', '78%'],
            itemStyle: {
                normal: {
                    label: {
                        show: false
                    },
                    labelLine: {
                        show: false
                    }
                }
            },
            data: [{
                    value: s1,
                    name: 'Sarjana'
                },
                {
                    value: s2,
                    name: 'Master'
                },
                {
                    value: s3,
                    name: 'Doktor'
                }
            ]
        }]
    });
}