$(document).on('click', '[data-toggle="lightbox"]', function(event) {
    event.preventDefault();
    $(this).ekkoLightbox();
});
$(document).ready(function() {
    $("#forgot-password").on("click", function() {
        $("#modalforgot").modal('show');
    });
    $("#submit-forgot").on("click", function() {
        submitForgot();
    });
    $("#submit-form").on("click", function() {
        submitData();
    });
    $("#hubungi-submit").on("click", function() {
        submitDataHubungi();
    });
    $("#main-form").validate({
        errorClass: 'validation-error-label',
        successClass: 'validation-valid-label',
        highlight: function(element, errorClass) {
            $(element).removeClass(errorClass);
            $('#panel-message').html('');
        },
        unhighlight: function(element, errorClass) {
            $(element).removeClass(errorClass);
            $('#panel-message').html('');
        },
        errorPlacement: function(error, element) {
            error.insertAfter(element);
        },
        validClass: "validation-valid-label",
        success: function(label) {},
        rules: {
            username: {
                required: true
            },
            password: {
                required: true
            },
        },
        messages: {
            username: {
                required: "Username Harus Diisi"
            },
            password: {
                required: "Password Harus Diisi"
            },
        },
        submitHandler: function(form) {
            // submitData();
        }
    });
    $("#hubungi-form").validate({
        errorClass: 'validation-error-label',
        successClass: 'validation-valid-label',
        highlight: function(element, errorClass) {
            $(element).removeClass(errorClass);
            $('#panel-message').html('');
        },
        unhighlight: function(element, errorClass) {
            $(element).removeClass(errorClass);
            $('#panel-message').html('');
        },
        errorPlacement: function(error, element) {
            error.insertAfter(element);
        },
        validClass: "validation-valid-label",
        success: function(label) {},
        rules: {
            email: {
                required: true
            },
            telepon: {
                required: true
            },
            nama: {
                required: true
            },
            pesan: {
                required: true
            }
        },
        messages: {
            email: {
                required: "Email Harus Diisi"
            },
            telepon: {
                required: "Telepon Harus Diisi"
            },
            nama: {
                required: "Nama Harus Diisi"
            },
            pesan: {
                required: "Pesan Harus Diisi"
            }
        },
        submitHandler: function(form) {
            // submitDataHubungi();
        }
    });
    $("#main-forgot").validate({
        errorClass: 'validation-error-label',
        successClass: 'validation-valid-label',
        highlight: function(element, errorClass) {
            $(element).removeClass(errorClass);
            $('#panel-message').html('');
        },
        unhighlight: function(element, errorClass) {
            $(element).removeClass(errorClass);
            $('#panel-message').html('');
        },
        errorPlacement: function(error, element) {
            error.insertAfter(element);
        },
        validClass: "validation-valid-label",
        success: function(label) {},
        rules: {
            email_forgot: {
                required: true
            }
        },
        messages: {
            email_forgot: {
                required: "Email Harus Diisi"
            },
        },
        submitHandler: function(form) {}
    });
});

function submitData() {
    if ($("#main-form").valid()) {
        var fd = $("#main-form").serializeArray();
        $.ajax({
            url: BASE_URL + '/login',
            type: "POST",
            data: fd,
            beforeSend: function() {
                $.blockUI({
                    message: 'Memproses data Anda...'
                });
            },
            success: function(data) {
                if (data.response.Status == 1) {
                    $.unblockUI();
                    $("#warningerror").modal('show');
                    $("#pesan").html(data.response.Message);
                } else {
                    window.location.href = BASE_URL + '/user';
                    $.unblockUI();
                }
            },
            error: function(xhr) {
                $.unblockUI();
            },
        });
    }
}

function submitDataHubungi() {
    if ($("#hubungi-form").valid()) {
        var fd = $("#hubungi-form").serializeArray();
        $.ajax({
            url: BASE_URL + '/simpan-hubungi-kami',
            type: "POST",
            data: fd,
            beforeSend: function() {
                $.blockUI({
                    message: 'Memproses data Anda...'
                });
            },
            success: function(data) {
                if (data.response.Status == 1) {
                    $.unblockUI();
                    $("#warningerror").modal('show');
                    $("#pesan").html("Terimkasih telah menghuungi kami. Dengan senang hati kami akan menindaklanjuti pesan Anda.");
                } else {
                    $("#warningerror").modal('show');
                    $("#pesan").html("");
                    $("#pesan").html(data.response.Message);
                    $('#hubungi-form')[0].reset();
                    $.unblockUI();
                }
            },
            error: function(xhr) {
                $.unblockUI();
            },
        });
    }
}

function submitForgot() {
    if ($("#main-forgot").valid()) {
        $("#modalforgot").modal('hide');
        var fd = $("#main-forgot").serializeArray();
        $.ajax({
            url: BASE_URL + '/forgot-password',
            type: "POST",
            data: fd,
            beforeSend: function() {
                $.blockUI({
                    message: 'Melakukan permintaan reset password...'
                });
            },
            success: function(data) {
                $("#main-forgot")[0].reset();
                $.unblockUI();
                $("#warningerror").modal('show');
                $("#pesan").html(data.response.Message);
            },
            error: function(xhr) {
                $.unblockUI();
            },
        });
    }
}